#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_ProductShipper : BaseTest 
	{
		private DataTable _dtProductShipper;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtProductShipper = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 PS.*, S.ShipmentGuid FROM ProductShipper PS  JOIN SHIPMENT S ON S.LocalSupplierGuid = PS.LocalSupplierGuid WHERE PS.RecordStatusCode = 'A' AND PS.DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' ORDER BY PS.LastUpdateDate DESC", true);

				this.RefreshData = false;
			}
		}

		[Test]
		public void GetProductShippersByDivision_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtProductShipper.Rows[0][TABLES.ProductShipper.BloodProductGuid];

			DataTable dtTest = DAL.ProductShipper.GetProductShippersByDivision(unitGuid);

			Assert.AreEqual(9, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.ProductShipperGuid), TABLES.ProductShipper.ProductShipperGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.BloodProductGuid), TABLES.ProductShipper.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.FacilityName), TABLES.LocalSupplier.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.LocalSupplierGuid), TABLES.LocalSupplier.LocalSupplierGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.RecordStatusCode), TABLES.ProductShipper.RecordStatusCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.ProductCost), TABLES.ProductShipper.ProductCost);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.ReturnCreditPercentage), TABLES.ProductShipper.ReturnCreditPercentage);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.DivisionCode), TABLES.ProductShipper.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.RowVersion), TABLES.ProductShipper.RowVersion);
		}

		[Test]
		public void GetProductShippersByDivision_Fail()
		{
			DataTable dtTest = DAL.ProductShipper.GetProductShippersByDivision(System.Guid.Empty);

			Assert.AreEqual(4, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.ProductShipperGuid), TABLES.ProductShipper.ProductShipperGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.LocalSupplierGuid), TABLES.LocalSupplier.LocalSupplierGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.FacilityName), TABLES.LocalSupplier.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.RecordStatusCode), TABLES.ProductShipper.RecordStatusCode);
		}
		
		[Test]
		public void GetProductShipperByGuid_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtProductShipper.Rows[0][TABLES.ProductShipper.ProductShipperGuid];

			DataTable dtTest = DAL.ProductShipper.GetProductShipperByGuid(unitGuid);

			Assert.AreEqual(9, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.ProductShipperGuid), TABLES.ProductShipper.ProductShipperGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.BloodProductGuid), TABLES.ProductShipper.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.DivisionCode), TABLES.ProductShipper.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.LocalSupplierGuid), TABLES.ProductShipper.LocalSupplierGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.RecordStatusCode), TABLES.ProductShipper.RecordStatusCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.ProductCost), TABLES.ProductShipper.ProductCost);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.ReturnCreditPercentage), TABLES.ProductShipper.ReturnCreditPercentage);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.LastUpdateUser), TABLES.ProductShipper.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.RowVersion), TABLES.ProductShipper.RowVersion);
		}

		[Test]
		public void GetProductShipperByGuid_Fail()
		{
			DataTable dtTest = DAL.ProductShipper.GetProductShipperByGuid(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetProductShipperByLocalSupplier_Pass()
		{
			System.Guid bpGuid = (System.Guid)this._dtProductShipper.Rows[0][TABLES.ProductShipper.BloodProductGuid];
			System.Guid lsGuid = (System.Guid)this._dtProductShipper.Rows[0][TABLES.ProductShipper.LocalSupplierGuid];

			DataTable dtTest = DAL.ProductShipper.GetProductShipperByLocalSupplier(bpGuid, lsGuid);

			Assert.AreEqual(9, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.ProductShipperGuid), TABLES.ProductShipper.ProductShipperGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.BloodProductGuid), TABLES.ProductShipper.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.DivisionCode), TABLES.ProductShipper.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.LocalSupplierGuid), TABLES.ProductShipper.LocalSupplierGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.RecordStatusCode), TABLES.ProductShipper.RecordStatusCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.ProductCost), TABLES.ProductShipper.ProductCost);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.ReturnCreditPercentage), TABLES.ProductShipper.ReturnCreditPercentage);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.LastUpdateUser), TABLES.ProductShipper.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.RowVersion), TABLES.ProductShipper.RowVersion);
		}

		[Test]
		public void GetProductShipperByLocalSupplier_Fail()
		{
			DataTable dtTest = DAL.ProductShipper.GetProductShipperByLocalSupplier(System.Guid.NewGuid(), System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetProductShipperFacilityName_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtProductShipper.Rows[0][TABLES.ProductShipper.LocalSupplierGuid];

			DataTable dtTest = DAL.ProductShipper.GetProductShipperFacilityName(unitGuid);

			Assert.AreEqual(2, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.FacilityName), TABLES.LocalSupplier.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.FdaRegistrationNumber), TABLES.LocalSupplier.FdaRegistrationNumber);
		}

		[Test]
		public void GetProductShipperFacilityName_Fail()
		{
			DataTable dtTest = DAL.ProductShipper.GetProductShipperFacilityName(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetProductShippersByDivisionLookUpList_Pass()
		{
			DataTable dtTest = DAL.ProductShipper.GetProductShippersByDivisionLookUpList();

			Assert.AreEqual(3, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.LocalSupplierGuid), TABLES.LocalSupplier.LocalSupplierGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.FacilityName), TABLES.LocalSupplier.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.LocalSupplier.FdaRegistrationNumber), TABLES.LocalSupplier.FdaRegistrationNumber);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetProductShippersByDivisionLookUpList_Fail()
		{
		}

		[Test]
		public void GetReimbursementPercentage_Pass()
		{
			DataRow drBloodUnit = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 BloodUnitGuid, LocalSupplierGuid FROM vw_BloodShipFinanceAllCurrent WHERE UnitStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");

			Guid unitGuid = (System.Guid)drBloodUnit[TABLES.BloodUnit.BloodUnitGuid];
			Guid localSupplierGuid = (System.Guid)drBloodUnit[TABLES.LocalSupplier.LocalSupplierGuid];

			decimal retValue = DAL.ProductShipper.GetReimbursementPercentage(unitGuid, localSupplierGuid);

			//Any value is ok
			Assert.AreEqual(true, retValue >= 0, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetReimbursementPercentage_Fail()
		{
			DAL.ProductShipper.GetReimbursementPercentage(System.Guid.NewGuid(), System.Guid.NewGuid());
		}

		[Test]
		public void GetEmptyProductShipperTable_Pass()
		{
			DataTable dtTest = DAL.ProductShipper.GetEmptyProductShipperTable(true);

			Assert.AreEqual(true, dtTest.TableName == TABLES.ProductShipper.TableName, "TableName");
			Assert.AreEqual(7, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.ProductCost), TABLES.ProductShipper.ProductCost);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.ProductShipperGuid), TABLES.ProductShipper.ProductShipperGuid);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.RecordStatusCode), TABLES.ProductShipper.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.ReturnCreditPercentage), TABLES.ProductShipper.ReturnCreditPercentage);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.LastUpdateUser), TABLES.ProductShipper.LastUpdateUser);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.LastUpdateFunctionId), TABLES.ProductShipper.LastUpdateFunctionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.RowVersion), TABLES.ProductShipper.RowVersion);
		}

		[Test]
		public void GetEmptyProductShipperTable_Fail()
		{
			DataTable dtTest = DAL.ProductShipper.GetEmptyProductShipperTable(false);

			Assert.AreEqual(true, dtTest.TableName == TABLES.ProductShipper.TableName, "TableName");
			Assert.AreEqual(9, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.BloodProductGuid), TABLES.ProductShipper.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.DivisionCode), TABLES.ProductShipper.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.LocalSupplierGuid), TABLES.ProductShipper.LocalSupplierGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.ProductCost), TABLES.ProductShipper.ProductCost);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.ProductShipperGuid), TABLES.ProductShipper.ProductShipperGuid);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.RecordStatusCode), TABLES.ProductShipper.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.ReturnCreditPercentage), TABLES.ProductShipper.ReturnCreditPercentage);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.LastUpdateUser), TABLES.ProductShipper.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductShipper.LastUpdateFunctionId), TABLES.ProductShipper.LastUpdateFunctionId);
		}

		[Test]
		public void InsertProductShipper_Pass()
		{
			this.RefreshData = true;

			System.Guid bpGuid = DataCreator.GetRecordGuid("SELECT TOP 1 BloodProductGuid FROM BloodProduct WHERE BloodProductGuid NOT IN (SELECT BloodProductGuid FROM ProductShipper)");

			DataTable dtTest = DAL.ProductShipper.GetEmptyProductShipperTable(false);

			DataRow dr = dtTest.NewRow();
			dr[TABLES.ProductShipper.BloodProductGuid] = bpGuid;
			dr[TABLES.ProductShipper.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			dr[TABLES.ProductShipper.LocalSupplierGuid] = this._dtProductShipper.Rows[0][TABLES.ProductShipper.LocalSupplierGuid];
			dr[TABLES.ProductShipper.ProductCost] = System.Convert.ToDecimal(new Random().Next(111,999));
			dr[TABLES.ProductShipper.ProductShipperGuid] = System.Guid.NewGuid();
			dr[TABLES.ProductShipper.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
			dr[TABLES.ProductShipper.ReturnCreditPercentage] = System.Convert.ToDecimal(new Random().Next(1,99));
			dr[TABLES.ProductShipper.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.ProductShipper.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dtTest.Rows.Add(dr);

			bool retValue = DAL.ProductShipper.InsertProductShipper(dtTest);

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(Common.UniqueDatabaseConstraintViolatedException))]
		public void InsertProductShipper_Fail()
		{
			this.RefreshData = true;

			DataTable dtTest = DAL.ProductShipper.GetEmptyProductShipperTable(false);

			DataRow dr = dtTest.NewRow();
			dr[TABLES.ProductShipper.BloodProductGuid] = this._dtProductShipper.Rows[0][TABLES.ProductShipper.BloodProductGuid];
			dr[TABLES.ProductShipper.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			dr[TABLES.ProductShipper.LocalSupplierGuid] = this._dtProductShipper.Rows[0][TABLES.ProductShipper.LocalSupplierGuid];
			dr[TABLES.ProductShipper.ProductCost] = System.Convert.ToDecimal(new Random().Next(111,999));
			dr[TABLES.ProductShipper.ProductShipperGuid] = this._dtProductShipper.Rows[0][TABLES.ProductShipper.ProductShipperGuid];
			dr[TABLES.ProductShipper.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
			dr[TABLES.ProductShipper.ReturnCreditPercentage] = System.Convert.ToDecimal(new Random().Next(1,99));
			dr[TABLES.ProductShipper.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.ProductShipper.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dtTest.Rows.Add(dr);

			DAL.ProductShipper.InsertProductShipper(dtTest);
		}


	}
}
#endif
